# coding: utf-8

# flake8: noqa
"""
    Titan API v1

    # Introduction The Intel 471 API is organized around the principles of REST. Our API lets you gather results from our platform using anything that can send a HTTP request, including cURL and modern internet browsers. Access to this API requires an API token which is managed from your account settings.  Intel 471 reserves the right to add fields to our API however we will provide backwards compatibility and older version support so that it will be possible to choose exact versions that provide a response with an older structure.  # Authentication Authentication to the API occurs by providing your email address as the login and API key as a password in the authorization header via HTTP Basic Auth. Your API key can be found in the [API](https://portal.intel471.com/api) section on the portal. It carries many privileges so please do not expose it on public web resources.  # Accessing the API  Following examples demonstrate different methods to get the reports from `/reports` endpoint.  ## Internet browser  Just open URL: https://api.intel471.com/v1/reports  Browser will ask you for credentials, provide your email as login and API key as password.  ## cURL command line utility  Execute following command in your terminal:  ``` curl -u <YOU EMAIL>:<YOUR API KEY> https://api.intel471.com/v1/reports ```  ## Python client  We provide a [Python client](https://github.com/intel471/titan-client-python) for Intel 471's Titan API, which aims at providing common ground for all the endpoints. Please note that all the call parameters and response body fields' names are normalized to camel_case, so for example when you search reports by document type using Python client use `document_type` instead of `documentType`.  Install the client using pip (python >= 3.6 required):  ``` pip install titan-client ```  Run following script  ```python import titan_client  configuration = titan_client.Configuration(     username=\"<YOU EMAIL>\",     password=\"<YOUR API KEY>\")  with titan_client.ApiClient(configuration) as api_client:     api_instance = titan_client.ReportsApi(api_client)     api_response = api_instance.reports_get() print(api_response) ```  # Use cases  Below we present several commonly used scenarios in both raw HTTP request format and as a script using Python client. Examples are simplified so that they do not contain the authentication part and for Python client they do not contain configuration and API client object creation portion. For full example please refer to **Accessing the API** section of this document.   ## Paging  One page of the results can carry up to 100 records and you can display up to 11 pages for one query (max offset is 1000) in non-stream API endpoints. Use `count` parameter to set the number of items per page. Use `offset` parameter to shift the window by given number of results.       **HTTP**   ``` # Get 20 reports, sorted by the default field GET https://api.intel471.com/v1/reports?count=20  # Get next 20 reports GET https://api.intel471.com/v1/reports?count=20&offset=20  # Get 40 reports in one go to save API calls GET https://api.intel471.com/v1/reports?count=40 ```  **Python**  ``` response = titan_client.ReportsApi(api_client).reports_get(count=20, offset=20) ```  ## Paging beyond the max allowed offset  Paging described in the previous use case is generally sufficient for most needs. If there are more than 1100 objects  to be obtained for a given time period and set of filter criteria, then it is possible to move the filter timestamps  along and then restart the offset sequencing. There is a very small number of situations where this may cause issues,  where there is multiple objects with the same timestamp adjacent to the last object in the response.  For the higher volume or fast changing data (such as malware indicators, malware events, creds) there are stream API endpoints  available where cursors may be used in order to acquire data easily and to avoid the need to shift timestamp ranges.  ``` # Get first 11 pages, 100 objects each  GET https://api.intel471.com/v1/reports?sort=latest&count=100 GET https://api.intel471.com/v1/reports?sort=latest&count=100&offset=100 ... GET https://api.intel471.com/v1/reports?sort=latest&count=100&offset=1000 ... > {\"reports\": [{..., \"created\": 1661867086000}, {..., \"created\": 1661864268000}]} ```  Then the `created` time value from the last response will be used as an upper limit in the next series of calls:  ```   GET https://api.intel471.com/v1/reports?sort=latest&until=1661864268000&count=100 GET https://api.intel471.com/v1/reports?sort=latest&until=1661864268000&offset=100 ... GET https://api.intel471.com/v1/reports?sort=latest&until=1661864268000&offset=1000 ```  And so on, until the results are available or until the desired number of objects has been fetched.  ## Paging /alerts endpoint  Alerts endpoint differs from all the other non-stream API endpoints in that the `offset` parameter needs to be set  to the uid of the most recent acquired alert instead of an integer indicating the shift.  **HTTP**   ``` GET https://api.intel471.com/v1/alerts?count=100 > {\"alerts\": [{..., \"uid\": \"abc123\"}, {..., \"uid\": \"abc234\"}]}  GET https://api.intel471.com/v1/alerts?count=100&offset=abc234 > {\"alerts\": [{..., \"uid\": \"abc345\"}, {..., \"uid\": \"abc456\"}]} ```  **Python**  ``` response = titan_client.AlertsApi(api_client).alerts_get(count=100, offset=\"abc456\") ```  ## Stream endpoints paging  Stream endpoints provide the same data as their regular counterparts but they differ in a way of paging.  When working with a stream endpoint, the response always contains `cursorNext` field, which should be provided to the next subsequent  call to fetch potential next page of the results. All the subsequent calls should have the same set of query parameters as the first one,  except the cursor value. Keep calling the endpoint with a new cursor value until it stops yielding results. When new data appear after that, another call will fetch it.  **HTTP**   ``` GET https://api.intel471.com/v1/indicators/stream?lastUpdatedFrom=1655809200000 > {\"indicators\": [...], \"cursorNext\": \"MTY1NT1\"}  GET https://api.intel471.com/v1/indicators/stream?lastUpdatedFrom=1655809200000&cursor=MTY1NT1 > {\"indicators\": [...], \"cursorNext\": \"MTY1NT2\"}  GET https://api.intel471.com/v1/indicators/stream?lastUpdatedFrom=1655809200000&cursor=MTY1NT2 > {\"cursorNext\": \"MTY1NT3\"} ```  **Python**  ``` response = titan_client.IndicatorsApi(api_client).indicators_stream_get(last_updated_from=1656809200000) print(response.cursor_next, response.indicators) # MTY1NT1, [...]  response = titan_client.IndicatorsApi(api_client).indicators_stream_get(last_updated_from=1656809200000, cursor=\"MTY1NT1\")) print(response.cursor_next, response.indicators) # MTY1NT2, [...]  response = titan_client.IndicatorsApi(api_client).indicators_stream_get(last_updated_from=1656809200000, cursor=\"MTY1NT2\")) print(response.cursor_next, response.indicators) # MTY1NT3, None ```  ## Querying using logical operators  ### Array parameters  Any query parameter can be singular or array, if multiple parameters with the same name were provided. All parameters with the same name are internally combined into a query with `AND` operator.  So following query:  ``` GET https://api.intel471.com/v1/reports?report=sources&report=abba ```  Means \"find me reports with `source` AND `abba` in their body\".  This approach is not supported in the Python client. Instead use query string method discussed below.   ### Query string parameters  Query parameters accept Elastic's query string syntax, which allows for even better flexibility.  For example above query can be rephrased as:  **HTTP**   ``` GET https://api.intel471.com/v1/reports?report=sources OR abba ```  **Python**  ``` response = titan_client.ReportsApi(api_client).reports_get(report=\"sources OR abba\") ```  More advanced combination would include both `OR` and `AND` operators and a negation:  **HTTP**  ``` GET https://api.intel471.com/v1/reports?report=(sources OR abba) AND -creaba ```  **Python**  ``` response = titan_client.ReportsApi(api_client).reports_get(report=\"(sources OR abba) AND -creaba\") ```  Means \"find me reports with `source` or `abba` in their body which at the same time do not contain `creaba`\".  The query string \"mini-language\" reference and examples can be found on  [Elastic's query string syntax](https://www.elastic.co/guide/en/elasticsearch/reference/7.5/query-dsl-query-string-query.html#query-dsl-query-string-query) page.  ## Get CVEs using multiple filtering criteria  Get all CVE reports for Chrome product where the risk is high and the patch is not available yet.  **HTTP**   ``` GET https://api.intel471.com/v1/cve/reports?productName=Chrome&riskLevel=high&patchStatus=unavailable ```  **Python**  ``` response = titan_client.VulnerabilitiesApi(api_client).cve_reports_get(     product_name=\"Chrome\",     risk_level=\"high\",     patch_status=\"unavailable\" ) ```  ## List watcher groups   **HTTP**   ``` GET https://api.intel471.com/v1/watcherGroups ```  **Python**  ``` response = titan_client.WatchersApi(api_client).watcher_groups_get() ```  ## Create watcher group   To create a watcher group you need to pass a body along with the request.  **HTTP**   ``` POST https://api.intel471.com/v1/watcherGroups {   \"name\": \"my_group_name\",   \"description\": \"My description\" } ```  **Python**  ``` response = titan_client.WatchersApi(api_client).watcher_groups_post(   {\"name\": \"my_group_name\", \"description\": \"My description\"} ) ```  ## Create free text search watcher  **HTTP**   ``` POST https://api.intel471.com/v1/watcherGroups/<GROUP UID>/watchers {   \"type\": \"search\",   \"freeTextPattern\": \"text to search\",   \"notificationChannel\": \"website\" } ```  **Python**  ``` response = titan_client.WatchersApi(api_client).watcher_groups_group_uid_watchers_post(   group_uid=\"<GROUP UID>\",   watcher_request_body_post={     \"type\": \"search\",     \"freeTextPattern\": \"text to search\",     \"notificationChannel\": \"website\"   } ) ```  ## Create specific search watcher  **HTTP**   ``` POST https://api.intel471.com/v1/watcherGroups/<GROUP UID>/watchers {   \"type\": \"search\",   \"patterns\": [     {\"types\": \"Actor\" , \"pattern\": \"swisman\"}   ],   \"notificationChannel\": \"website\" } ```  **Python**  ``` response = titan_client.WatchersApi(api_client).watcher_groups_group_uid_watchers_post(   group_uid=\"<GROUP UID>\",   watcher_request_body_post={     \"type\": \"search\",     \"patterns\": [       {\"types\": \"Actor\" , \"pattern\": \"swisman\"}     ],     \"notificationChannel\": \"website\"   } ) ```  # API integration best practice with your application CORS requests to the API are not allowed due to security concerns, so please avoid AJAX calls directly from the browser. Instead consider setting up a server side proxy in your application to handle API requests.  Please consider not storing information provided by the API locally as we are constantly improving our data set and want you to have the most updated information.  # Versioning support We consistently improve our API and occasionally introduce the changes based on the customer feedback. The current API version is provided in this documentation's header. We provide API backwards compatibility whenever possible.  All requests are prefixed with the major version number, for example `/v1`:  ``` https://api.intel471.com/v1/reports ```  Different major versions are not compatible and imply significant response structure changes. Minor versions differences might include extra fields in response or provide new request parameter support. To stick to the specific version, just add `v` parameter to the request, for example: `?v=1.19.2`. If you specify a non existing version, it will be brought down to the nearest existing one.  Omitting the version parameter in the request will call the latest version of the API.  We consistently phase out the outdated versions of the API, keeping only several most recent versions. Specific version is getting disabled only when we do not record any requests using it, so it's guaranteed that calls to the outdated ones will work, though we recommend switching to the latest one as soon as possible.  We recommend to always add the version parameter to the request to be safe on API updates in your integrations.   Python client always adds the version parameter in the underlying request. API version matches the Python client's package version.   # noqa: E501

    The version of the OpenAPI document: 1.19.2
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

# import models into model package
from titan_client.models.alert_list_schema import AlertListSchema
from titan_client.models.alert_list_schema_chunks import AlertListSchemaChunks
from titan_client.models.alert_list_schema_highlights import AlertListSchemaHighlights
from titan_client.models.alert_list_schema_report import AlertListSchemaReport
from titan_client.models.alert_list_schema_response import AlertListSchemaResponse
from titan_client.models.credential_accessed_url_schema import CredentialAccessedUrlSchema
from titan_client.models.credential_accessed_url_schema_activity import CredentialAccessedUrlSchemaActivity
from titan_client.models.credential_accessed_url_schema_classification import CredentialAccessedUrlSchemaClassification
from titan_client.models.credential_accessed_url_schema_data import CredentialAccessedUrlSchemaData
from titan_client.models.credential_accessed_url_schema_data_credential import CredentialAccessedUrlSchemaDataCredential
from titan_client.models.credential_accessed_url_stream_schema import CredentialAccessedUrlStreamSchema
from titan_client.models.credential_accessed_urls_response import CredentialAccessedUrlsResponse
from titan_client.models.credential_accessed_urls_stream_response import CredentialAccessedUrlsStreamResponse
from titan_client.models.credential_occurrence_schema import CredentialOccurrenceSchema
from titan_client.models.credential_occurrence_schema_activity import CredentialOccurrenceSchemaActivity
from titan_client.models.credential_occurrence_schema_classification import CredentialOccurrenceSchemaClassification
from titan_client.models.credential_occurrence_schema_data import CredentialOccurrenceSchemaData
from titan_client.models.credential_occurrence_schema_data_credential import CredentialOccurrenceSchemaDataCredential
from titan_client.models.credential_occurrence_schema_data_credential_set import CredentialOccurrenceSchemaDataCredentialSet
from titan_client.models.credential_occurrences_response import CredentialOccurrencesResponse
from titan_client.models.credential_occurrences_stream_response import CredentialOccurrencesStreamResponse
from titan_client.models.credential_schema import CredentialSchema
from titan_client.models.credential_schema_activity import CredentialSchemaActivity
from titan_client.models.credential_schema_classification import CredentialSchemaClassification
from titan_client.models.credential_schema_data import CredentialSchemaData
from titan_client.models.credential_schema_data_credential_sets import CredentialSchemaDataCredentialSets
from titan_client.models.credential_schema_data_password import CredentialSchemaDataPassword
from titan_client.models.credential_schema_data_password_complexity import CredentialSchemaDataPasswordComplexity
from titan_client.models.credential_schema_statistics import CredentialSchemaStatistics
from titan_client.models.credential_set_accessed_url_schema import CredentialSetAccessedUrlSchema
from titan_client.models.credential_set_accessed_url_schema_activity import CredentialSetAccessedUrlSchemaActivity
from titan_client.models.credential_set_accessed_url_schema_classification import CredentialSetAccessedUrlSchemaClassification
from titan_client.models.credential_set_accessed_url_schema_data import CredentialSetAccessedUrlSchemaData
from titan_client.models.credential_set_accessed_url_schema_data_credential_set import CredentialSetAccessedUrlSchemaDataCredentialSet
from titan_client.models.credential_set_accessed_url_stream_schema import CredentialSetAccessedUrlStreamSchema
from titan_client.models.credential_set_accessed_url_stream_schema_data import CredentialSetAccessedUrlStreamSchemaData
from titan_client.models.credential_set_schema import CredentialSetSchema
from titan_client.models.credential_set_schema_activity import CredentialSetSchemaActivity
from titan_client.models.credential_set_schema_classification import CredentialSetSchemaClassification
from titan_client.models.credential_set_schema_data import CredentialSetSchemaData
from titan_client.models.credential_set_schema_data_external_sources import CredentialSetSchemaDataExternalSources
from titan_client.models.credential_set_schema_data_internal_sources import CredentialSetSchemaDataInternalSources
from titan_client.models.credential_set_schema_data_victims import CredentialSetSchemaDataVictims
from titan_client.models.credential_set_schema_statistics import CredentialSetSchemaStatistics
from titan_client.models.credential_set_stream_schema import CredentialSetStreamSchema
from titan_client.models.credential_set_stream_schema_data import CredentialSetStreamSchemaData
from titan_client.models.credential_sets_accessed_urls_response import CredentialSetsAccessedUrlsResponse
from titan_client.models.credential_sets_accessed_urls_stream_response import CredentialSetsAccessedUrlsStreamResponse
from titan_client.models.credential_sets_response import CredentialSetsResponse
from titan_client.models.credential_sets_stream_response import CredentialSetsStreamResponse
from titan_client.models.credentials_response import CredentialsResponse
from titan_client.models.credentials_stream_response import CredentialsStreamResponse
from titan_client.models.entities_response import EntitiesResponse
from titan_client.models.entities_schema import EntitiesSchema
from titan_client.models.entities_schema_links import EntitiesSchemaLinks
from titan_client.models.entities_schema_links_actors import EntitiesSchemaLinksActors
from titan_client.models.entities_schema_links_reports import EntitiesSchemaLinksReports
from titan_client.models.event_schema import EventSchema
from titan_client.models.event_schema_activity import EventSchemaActivity
from titan_client.models.event_schema_data import EventSchemaData
from titan_client.models.event_schema_data_event_data import EventSchemaDataEventData
from titan_client.models.event_schema_data_event_data_controller import EventSchemaDataEventDataController
from titan_client.models.event_schema_data_event_data_controller_geo_ip import EventSchemaDataEventDataControllerGeoIp
from titan_client.models.event_schema_data_event_data_controller_geo_ip_isp import EventSchemaDataEventDataControllerGeoIpIsp
from titan_client.models.event_schema_data_event_data_controllers import EventSchemaDataEventDataControllers
from titan_client.models.event_schema_data_event_data_encryption import EventSchemaDataEventDataEncryption
from titan_client.models.event_schema_data_event_data_file import EventSchemaDataEventDataFile
from titan_client.models.event_schema_data_event_data_location import EventSchemaDataEventDataLocation
from titan_client.models.event_schema_data_event_data_recipient_domains import EventSchemaDataEventDataRecipientDomains
from titan_client.models.event_schema_data_event_data_triggers import EventSchemaDataEventDataTriggers
from titan_client.models.event_schema_data_threat import EventSchemaDataThreat
from titan_client.models.event_schema_data_threat_data import EventSchemaDataThreatData
from titan_client.models.event_schema_meta import EventSchemaMeta
from titan_client.models.event_stream_response import EventStreamResponse
from titan_client.models.events_response import EventsResponse
from titan_client.models.full_breach_alert_schema import FullBreachAlertSchema
from titan_client.models.full_breach_alert_schema_all_of import FullBreachAlertSchemaAllOf
from titan_client.models.full_cve_schema import FullCveSchema
from titan_client.models.full_news_schema import FullNewsSchema
from titan_client.models.full_report_schema import FullReportSchema
from titan_client.models.full_report_schema_all_of import FullReportSchemaAllOf
from titan_client.models.full_spot_report_schema import FullSpotReportSchema
from titan_client.models.full_watcher_group_schema import FullWatcherGroupSchema
from titan_client.models.full_watcher_group_schema_all_of import FullWatcherGroupSchemaAllOf
from titan_client.models.full_watcher_group_schema_all_of_links import FullWatcherGroupSchemaAllOfLinks
from titan_client.models.full_watcher_group_schema_all_of_links_forum import FullWatcherGroupSchemaAllOfLinksForum
from titan_client.models.full_watcher_group_schema_all_of_links_thread import FullWatcherGroupSchemaAllOfLinksThread
from titan_client.models.full_watcher_group_schema_all_of_patterns import FullWatcherGroupSchemaAllOfPatterns
from titan_client.models.full_watcher_group_schema_all_of_watchers import FullWatcherGroupSchemaAllOfWatchers
from titan_client.models.gir_schema import GirSchema
from titan_client.models.gir_schema_data import GirSchemaData
from titan_client.models.gir_schema_data_gir import GirSchemaDataGir
from titan_client.models.girs_response import GirsResponse
from titan_client.models.indicator_search_response import IndicatorSearchResponse
from titan_client.models.indicator_search_schema import IndicatorSearchSchema
from titan_client.models.indicator_search_schema_activity import IndicatorSearchSchemaActivity
from titan_client.models.indicator_search_schema_data import IndicatorSearchSchemaData
from titan_client.models.indicator_search_schema_data_context import IndicatorSearchSchemaDataContext
from titan_client.models.indicator_search_schema_data_indicator_data import IndicatorSearchSchemaDataIndicatorData
from titan_client.models.indicator_search_schema_data_indicator_data_file import IndicatorSearchSchemaDataIndicatorDataFile
from titan_client.models.indicator_search_schema_data_threat import IndicatorSearchSchemaDataThreat
from titan_client.models.indicator_search_schema_data_threat_data import IndicatorSearchSchemaDataThreatData
from titan_client.models.indicator_search_schema_meta import IndicatorSearchSchemaMeta
from titan_client.models.indicator_stream_response import IndicatorStreamResponse
from titan_client.models.inline_object import InlineObject
from titan_client.models.inline_object1 import InlineObject1
from titan_client.models.instant_message_schema import InstantMessageSchema
from titan_client.models.instant_message_schema_activity import InstantMessageSchemaActivity
from titan_client.models.instant_message_schema_data import InstantMessageSchemaData
from titan_client.models.instant_message_schema_data_actor import InstantMessageSchemaDataActor
from titan_client.models.instant_message_schema_data_channel import InstantMessageSchemaDataChannel
from titan_client.models.instant_message_schema_data_message import InstantMessageSchemaDataMessage
from titan_client.models.instant_message_schema_data_message_attachments import InstantMessageSchemaDataMessageAttachments
from titan_client.models.instant_message_schema_data_server import InstantMessageSchemaDataServer
from titan_client.models.ioc_schema import IocSchema
from titan_client.models.ioc_schema_links import IocSchemaLinks
from titan_client.models.ioc_schema_links_actors import IocSchemaLinksActors
from titan_client.models.ioc_schema_links_reports import IocSchemaLinksReports
from titan_client.models.iocs_response import IocsResponse
from titan_client.models.malware import Malware
from titan_client.models.malware_reports_search_response import MalwareReportsSearchResponse
from titan_client.models.malware_reports_search_schema import MalwareReportsSearchSchema
from titan_client.models.malware_reports_search_schema_activity import MalwareReportsSearchSchemaActivity
from titan_client.models.malware_reports_search_schema_classification import MalwareReportsSearchSchemaClassification
from titan_client.models.malware_reports_search_schema_data import MalwareReportsSearchSchemaData
from titan_client.models.malware_reports_search_schema_data_malware_report_data import MalwareReportsSearchSchemaDataMalwareReportData
from titan_client.models.malware_reports_search_schema_data_malware_report_data_attachments import MalwareReportsSearchSchemaDataMalwareReportDataAttachments
from titan_client.models.malware_reports_search_schema_data_threat import MalwareReportsSearchSchemaDataThreat
from titan_client.models.malware_reports_search_schema_data_threat_data import MalwareReportsSearchSchemaDataThreatData
from titan_client.models.messaging_services_response import MessagingServicesResponse
from titan_client.models.news_schema import NewsSchema
from titan_client.models.news_schema_activity import NewsSchemaActivity
from titan_client.models.news_schema_data import NewsSchemaData
from titan_client.models.news_schema_data_attachments import NewsSchemaDataAttachments
from titan_client.models.pcap_response import PCAPResponse
from titan_client.models.pcap_schema import PCAPSchema
from titan_client.models.pcap_schema_data import PCAPSchemaData
from titan_client.models.pcap_schema_data_file import PCAPSchemaDataFile
from titan_client.models.pcap_schema_data_malware_family import PCAPSchemaDataMalwareFamily
from titan_client.models.pcap_schema_data_pcap import PCAPSchemaDataPcap
from titan_client.models.post_schema import PostSchema
from titan_client.models.post_schema_links import PostSchemaLinks
from titan_client.models.post_schema_links_author_actor import PostSchemaLinksAuthorActor
from titan_client.models.post_schema_links_forum import PostSchemaLinksForum
from titan_client.models.post_schema_links_thread import PostSchemaLinksThread
from titan_client.models.posts_response import PostsResponse
from titan_client.models.private_message_schema import PrivateMessageSchema
from titan_client.models.private_message_schema_links import PrivateMessageSchemaLinks
from titan_client.models.private_message_schema_links_author_actor import PrivateMessageSchemaLinksAuthorActor
from titan_client.models.private_message_schema_links_forum import PrivateMessageSchemaLinksForum
from titan_client.models.private_message_schema_links_recipient_actor import PrivateMessageSchemaLinksRecipientActor
from titan_client.models.private_messages_response import PrivateMessagesResponse
from titan_client.models.search_schema import SearchSchema
from titan_client.models.simple_actor_schema import SimpleActorSchema
from titan_client.models.simple_actor_schema_links import SimpleActorSchemaLinks
from titan_client.models.simple_actor_schema_links_contact_info import SimpleActorSchemaLinksContactInfo
from titan_client.models.simple_actor_schema_links_forums import SimpleActorSchemaLinksForums
from titan_client.models.simple_actor_schema_links_instant_message_servers import SimpleActorSchemaLinksInstantMessageServers
from titan_client.models.simple_actors_response import SimpleActorsResponse
from titan_client.models.simple_breach_alert_response import SimpleBreachAlertResponse
from titan_client.models.simple_breach_alert_schema import SimpleBreachAlertSchema
from titan_client.models.simple_breach_alert_schema_activity import SimpleBreachAlertSchemaActivity
from titan_client.models.simple_breach_alert_schema_data import SimpleBreachAlertSchemaData
from titan_client.models.simple_breach_alert_schema_data_breach_alert import SimpleBreachAlertSchemaDataBreachAlert
from titan_client.models.simple_breach_alert_schema_data_breach_alert_confidence import SimpleBreachAlertSchemaDataBreachAlertConfidence
from titan_client.models.simple_breach_alert_schema_data_breach_alert_sources import SimpleBreachAlertSchemaDataBreachAlertSources
from titan_client.models.simple_breach_alert_schema_data_breach_alert_victim import SimpleBreachAlertSchemaDataBreachAlertVictim
from titan_client.models.simple_breach_alert_schema_data_breach_alert_victim_industries import SimpleBreachAlertSchemaDataBreachAlertVictimIndustries
from titan_client.models.simple_breach_alert_schema_data_entities import SimpleBreachAlertSchemaDataEntities
from titan_client.models.simple_breach_alert_schema_data_geo_info import SimpleBreachAlertSchemaDataGeoInfo
from titan_client.models.simple_cve_schema import SimpleCveSchema
from titan_client.models.simple_cve_schema_activity import SimpleCveSchemaActivity
from titan_client.models.simple_cve_schema_classification import SimpleCveSchemaClassification
from titan_client.models.simple_cve_schema_data import SimpleCveSchemaData
from titan_client.models.simple_cve_schema_data_cve_report import SimpleCveSchemaDataCveReport
from titan_client.models.simple_cve_schema_data_cve_report_activity_location import SimpleCveSchemaDataCveReportActivityLocation
from titan_client.models.simple_cve_schema_data_cve_report_counter_measure_links import SimpleCveSchemaDataCveReportCounterMeasureLinks
from titan_client.models.simple_cve_schema_data_cve_report_cvss_score import SimpleCveSchemaDataCveReportCvssScore
from titan_client.models.simple_cve_schema_data_cve_report_exploit_status import SimpleCveSchemaDataCveReportExploitStatus
from titan_client.models.simple_cve_schema_data_cve_report_interest_level import SimpleCveSchemaDataCveReportInterestLevel
from titan_client.models.simple_cve_schema_data_cve_report_patch_links import SimpleCveSchemaDataCveReportPatchLinks
from titan_client.models.simple_cve_schema_data_cve_report_poc_links import SimpleCveSchemaDataCveReportPocLinks
from titan_client.models.simple_cve_schema_data_cve_report_titan_links import SimpleCveSchemaDataCveReportTitanLinks
from titan_client.models.simple_cves_response import SimpleCvesResponse
from titan_client.models.simple_news_response import SimpleNewsResponse
from titan_client.models.simple_report_schema import SimpleReportSchema
from titan_client.models.simple_report_schema_actor_subject_of_report import SimpleReportSchemaActorSubjectOfReport
from titan_client.models.simple_report_schema_classification import SimpleReportSchemaClassification
from titan_client.models.simple_report_schema_entities import SimpleReportSchemaEntities
from titan_client.models.simple_report_schema_locations import SimpleReportSchemaLocations
from titan_client.models.simple_report_schema_related_reports import SimpleReportSchemaRelatedReports
from titan_client.models.simple_report_schema_report_attachments import SimpleReportSchemaReportAttachments
from titan_client.models.simple_report_schema_sources import SimpleReportSchemaSources
from titan_client.models.simple_report_schema_victims import SimpleReportSchemaVictims
from titan_client.models.simple_reports_response import SimpleReportsResponse
from titan_client.models.simple_spot_report_schema import SimpleSpotReportSchema
from titan_client.models.simple_spot_report_schema_activity import SimpleSpotReportSchemaActivity
from titan_client.models.simple_spot_report_schema_data import SimpleSpotReportSchemaData
from titan_client.models.simple_spot_report_schema_data_entities import SimpleSpotReportSchemaDataEntities
from titan_client.models.simple_spot_report_schema_data_spot_report import SimpleSpotReportSchemaDataSpotReport
from titan_client.models.simple_spot_report_schema_data_spot_report_spot_report_data import SimpleSpotReportSchemaDataSpotReportSpotReportData
from titan_client.models.simple_spot_report_schema_data_spot_report_spot_report_data_links import SimpleSpotReportSchemaDataSpotReportSpotReportDataLinks
from titan_client.models.simple_spot_report_schema_data_spot_report_spot_report_data_victims import SimpleSpotReportSchemaDataSpotReportSpotReportDataVictims
from titan_client.models.simple_spot_reports_response import SimpleSpotReportsResponse
from titan_client.models.simple_watcher_group_schema import SimpleWatcherGroupSchema
from titan_client.models.situation_report_response import SituationReportResponse
from titan_client.models.situation_report_schema import SituationReportSchema
from titan_client.models.situation_report_schema_activity import SituationReportSchemaActivity
from titan_client.models.situation_report_schema_classification import SituationReportSchemaClassification
from titan_client.models.situation_report_schema_data import SituationReportSchemaData
from titan_client.models.situation_report_schema_data_situation_report import SituationReportSchemaDataSituationReport
from titan_client.models.situation_report_schema_data_situation_report_entities import SituationReportSchemaDataSituationReportEntities
from titan_client.models.situation_report_schema_data_situation_report_link import SituationReportSchemaDataSituationReportLink
from titan_client.models.situation_report_schema_data_situation_report_link_malware_family import SituationReportSchemaDataSituationReportLinkMalwareFamily
from titan_client.models.situation_report_schema_data_situation_report_link_malware_report import SituationReportSchemaDataSituationReportLinkMalwareReport
from titan_client.models.situation_report_schema_data_situation_report_victims import SituationReportSchemaDataSituationReportVictims
from titan_client.models.tag_response import TagResponse
from titan_client.models.tag_schema import TagSchema
from titan_client.models.watcher_group_response import WatcherGroupResponse
from titan_client.models.watcher_request_body import WatcherRequestBody
from titan_client.models.watcher_request_body_filters import WatcherRequestBodyFilters
from titan_client.models.watcher_request_body_patterns import WatcherRequestBodyPatterns
from titan_client.models.watcher_request_body_post import WatcherRequestBodyPost
from titan_client.models.watcher_request_body_post_all_of import WatcherRequestBodyPostAllOf
from titan_client.models.watcher_request_body_put import WatcherRequestBodyPut
from titan_client.models.watcher_request_body_put_all_of import WatcherRequestBodyPutAllOf
from titan_client.models.watcher_schema import WatcherSchema
from titan_client.models.watcher_schema_filters import WatcherSchemaFilters
from titan_client.models.watcher_schema_forum import WatcherSchemaForum
from titan_client.models.watcher_schema_links import WatcherSchemaLinks
from titan_client.models.watcher_schema_patterns import WatcherSchemaPatterns
from titan_client.models.watcher_schema_response import WatcherSchemaResponse
from titan_client.models.watcher_schema_thread import WatcherSchemaThread
from titan_client.models.yara_search_response import YARASearchResponse
from titan_client.models.yara_search_schema import YARASearchSchema
from titan_client.models.yara_search_schema_activity import YARASearchSchemaActivity
from titan_client.models.yara_search_schema_data import YARASearchSchemaData
from titan_client.models.yara_search_schema_data_threat import YARASearchSchemaDataThreat
from titan_client.models.yara_search_schema_data_threat_data import YARASearchSchemaDataThreatData
from titan_client.models.yara_search_schema_data_yara_data import YARASearchSchemaDataYaraData
from titan_client.models.yara_search_schema_meta import YARASearchSchemaMeta
